<?php

namespace App\Http\Requests\Settings;

use Illuminate\Foundation\Http\FormRequest;

class PusherRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return $this->user()->can('pusher settings');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
                'broadcast_driver' => 'required|string',
                'app_id'           => 'required|numeric',
                'app_key'          => 'required',
                'app_secret'       => 'required',
                'app_cluster'      => 'required',
        ];
    }
}
