<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PhoneNumberWithCountryCode;

/**
 * Builder for model PhoneNumberWithCountryCode
 *
 * @see PhoneNumberWithCountryCode
 */
class PhoneNumberWithCountryCodeBuilder
{
    /**
     * @var PhoneNumberWithCountryCode
     */
    private $instance;

    private function __construct(PhoneNumberWithCountryCode $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new phone number with country code Builder object.
     */
    public static function init(string $countryCode, string $nationalNumber): self
    {
        return new self(new PhoneNumberWithCountryCode($countryCode, $nationalNumber));
    }

    /**
     * Initializes a new phone number with country code object.
     */
    public function build(): PhoneNumberWithCountryCode
    {
        return CoreHelper::clone($this->instance);
    }
}
